using System;
using System.Collections.Generic;
using System.Text;
using ComponentPro;

namespace AdvancedDemo.Samples.Function_and_Property
{
    class ArticleAuthor
    {
        public string FullName
        {
            get
            {
                return "Leo Dang";
            }
        }
    }

    class Article
    {
        public int ArticleId
        {
            get
            {
                return 100;
            }
        }
        public ArticleAuthor ArticleAuthor
        {
            get
            {
                return new ArticleAuthor();
            }
        }
        public string GetFullName()
        {
            return this.ArticleAuthor.FullName.ToUpper();
        }
    }

    class Dot_NET_Support : TemplateExampleBase
    {
        /// <summary>
        /// Generates output from a template file.
        /// </summary>
        /// <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
        /// <param name="templateFile">The template file path.</param>
        /// <param name="templateSource">The template source loaded from the template file.</param>
        /// <returns>The generated output.</returns>
        public override string Generate(string templateSourceDirectory, string templateFile, string templateSource)
        {
            // Create a new instance of the TemplateEngine class.
            TemplateEngine dt = new TemplateEngine();

            // Load template content from a file.
            dt.LoadFromString(templateSource);
            dt.SetValue("TemplateSourceDirectory", templateSourceDirectory);

            Article art = new Article();
            dt.SetValue("art", art);

            // Generate output.
            string output = dt.Run();

            return output;
        }
    }
}
